/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.ui.bonsai.earth;

import com.ibm.hwmca.fw.ui.UIInfo;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.ui.bonsai.config.AbstractNodeConfigBean;
import com.ibm.hwmca.ui.bonsai.config.UIInfoConfigBean;
import com.ibm.hwmca.ui.bonsai.config.WorkareaConfigBean;
import com.ibm.hwmca.ui.bonsai.earth.BonsaiTreeNode;
import com.ibm.hwmca.ui.bonsai.earth.TaskManager;
import com.ibm.hwmca.ui.bonsai.earth.util.Filter;
import com.ibm.hwmca.ui.bonsai.earth.util.FilterResult;
import com.ibm.hwmca.ui.bonsai.earth.util.TaskRetriever;
import com.ibm.hwmca.ui.bonsai.servlet.util.UserObject;
import com.ibm.hwmca.ui.bonsai.table.NameTableCellBean;
import com.ibm.hwmca.ui.bonsai.tree.NavigationTreeNodeBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public abstract class AbstractTreeNode
implements BonsaiTreeNode {
    protected static final Set TABLE_PROPERTIES = new HashSet(4);
    private final Object CHILDREN_LOCK_OBJECT = new Object();
    private String id;
    private AbstractNodeConfigBean configBean;
    private Set filters;
    private UIInfo uiinfo;
    private String workarea;
    private boolean uriWorkarea;
    private Map workareaParams;
    private Map workareaStyles;
    private BonsaiTreeNode parent;
    private List children;
    private String taskRetrieverKey;

    protected AbstractTreeNode(AbstractTreeNode clonee, BonsaiTreeNode parent) {
        this(clonee, parent, clonee.getXMLKey());
    }

    protected AbstractTreeNode(AbstractTreeNode clonee, BonsaiTreeNode parent, String idPostfix) {
        this.id = parent == null ? idPostfix : parent.getId() + ":" + idPostfix;
        this.configBean = clonee.configBean;
        this.filters = clonee.filters;
        this.uiinfo = clonee.uiinfo;
        this.workarea = clonee.workarea;
        this.uriWorkarea = clonee.uriWorkarea;
        this.workareaParams = clonee.workareaParams;
        this.workareaStyles = clonee.workareaStyles;
        this.parent = parent;
        this.children = new ArrayList();
        this.taskRetrieverKey = clonee.taskRetrieverKey;
    }

    protected AbstractTreeNode(AbstractNodeConfigBean configBean, BonsaiTreeNode parent, WorkareaConfigBean defaultWorkarea, Set filters) {
        this(configBean, parent, defaultWorkarea, filters, configBean.getKey());
    }

    protected AbstractTreeNode(AbstractNodeConfigBean configBean, BonsaiTreeNode parent, WorkareaConfigBean defaultWorkarea, Set filters, String idPostfix) {
        this.id = parent == null ? idPostfix : parent.getId() + ":" + idPostfix;
        this.configBean = configBean;
        this.filters = filters == null ? new HashSet(0) : filters;
        this.parent = parent;
        this.children = new ArrayList();
        this.taskRetrieverKey = configBean.getTaskRetrieverKey();
        WorkareaConfigBean waBean = configBean.getWorkarea();
        if (waBean == null) {
            waBean = defaultWorkarea;
        }
        this.workarea = waBean.getWorkarea();
        this.uriWorkarea = waBean.isTypeUri();
        this.workareaParams = waBean.getParameters();
        this.workareaStyles = waBean.getStyles();
        UIInfoConfigBean uiConfigBean = configBean.getUIInfo();
        if (uiConfigBean != null) {
            String bundle = uiConfigBean.getResourceBundle();
            LocalizableText name = new LocalizableText(bundle, uiConfigBean.getName());
            LocalizableText caption = new LocalizableText(bundle, uiConfigBean.getCaption());
            String image = uiConfigBean.getImageName();
            this.uiinfo = image == null ? new UIInfo(name, caption) : new UIInfo(name, caption, uiConfigBean.getImagePath() + image);
        }
    }

    public String getId() {
        return this.id;
    }

    public String getXMLKey() {
        return this.configBean.getKey();
    }

    public AbstractNodeConfigBean getConfigBean() {
        return this.configBean;
    }

    protected boolean hasShownChildren(UserObject userObj) {
        BonsaiTreeNode child = null;
        Iterator i = this.getChildren().iterator();
        while (i.hasNext()) {
            child = (BonsaiTreeNode)i.next();
            if (!child.isShown(userObj, false) && !child.isShown(userObj, true)) continue;
            return true;
        }
        return false;
    }

    protected FilterResult getFilterResult(UserObject userObj, boolean inTree) {
        FilterResult result = new FilterResult(false, false);
        Filter filter = null;
        Iterator i = this.filters.iterator();
        while (i.hasNext()) {
            filter = (Filter)i.next();
            result.merge(filter.getFilterResult(this, userObj, inTree));
        }
        return result;
    }

    public UIInfo getUIInfo() {
        return this.uiinfo;
    }

    public String getWorkarea() {
        return this.workarea;
    }

    public boolean isUriWorkarea() {
        return this.uriWorkarea;
    }

    public Map getWorkareaParameters() {
        return this.workareaParams;
    }

    public Map getWorkareaStyles() {
        return this.workareaStyles;
    }

    public BonsaiTreeNode getParent() {
        return this.parent;
    }

    public boolean isAncestor(BonsaiTreeNode node) {
        while ((node = node.getParent()) != null) {
            if (!this.equals(node)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(BonsaiTreeNode childNode) {
        Object object = this.CHILDREN_LOCK_OBJECT;
        synchronized (object) {
            this.children.add(childNode);
        }
    }

    public void addChildren(List childNodes) {
        Iterator i = childNodes.iterator();
        while (i.hasNext()) {
            this.addChild((BonsaiTreeNode)i.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getChildren() {
        Object object = this.CHILDREN_LOCK_OBJECT;
        synchronized (object) {
            return new ArrayList(this.children);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replaceChild(String id, BonsaiTreeNode childNode) {
        Object object = this.CHILDREN_LOCK_OBJECT;
        synchronized (object) {
            int index = this.indexOfChild(id);
            if (index < 0) {
                return false;
            }
            this.children.set(index, childNode);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeChild(String id) {
        Object object = this.CHILDREN_LOCK_OBJECT;
        synchronized (object) {
            int index = this.indexOfChild(id);
            if (index < 0) {
                return false;
            }
            this.children.remove(index);
            return true;
        }
    }

    public void prepareForActivation() {
        Iterator i = this.getChildren().iterator();
        while (i.hasNext()) {
            ((BonsaiTreeNode)i.next()).prepareForActivation();
        }
    }

    public void prepareForRemoval() {
        Iterator i = this.getChildren().iterator();
        while (i.hasNext()) {
            ((BonsaiTreeNode)i.next()).prepareForRemoval();
        }
    }

    public void prepareForReplacement(BonsaiTreeNode node) {
        List children = this.getChildren();
        List replacementsChildren = node.getChildren();
        HashSet temp = null;
        BonsaiTreeNode child = null;
        temp = new HashSet(children);
        temp.retainAll(replacementsChildren);
        Iterator i = temp.iterator();
        while (i.hasNext()) {
            child = (BonsaiTreeNode)i.next();
            child.prepareForReplacement((BonsaiTreeNode)replacementsChildren.get(replacementsChildren.indexOf(child)));
        }
        temp = new HashSet(children);
        temp.removeAll(replacementsChildren);
        i = temp.iterator();
        while (i.hasNext()) {
            ((BonsaiTreeNode)i.next()).prepareForRemoval();
        }
        temp = new HashSet(replacementsChildren);
        temp.removeAll(children);
        i = temp.iterator();
        while (i.hasNext()) {
            ((BonsaiTreeNode)i.next()).prepareForActivation();
        }
    }

    protected void copyChildren(BonsaiTreeNode clonee) {
        Iterator i = clonee.getChildren().iterator();
        while (i.hasNext()) {
            this.addChild(((BonsaiTreeNode)i.next()).getCopy(this, true));
        }
    }

    private int indexOfChild(String id) {
        int size = this.children.size();
        for (int i = 0; i < size; ++i) {
            if (!((BonsaiTreeNode)this.children.get(i)).getId().equals(id)) continue;
            return i;
        }
        return -1;
    }

    public String getTaskRetrieverKey() {
        return this.taskRetrieverKey;
    }

    public List getTasks(UserObject userObj) {
        if (this.taskRetrieverKey == null) {
            return new ArrayList(0);
        }
        return this.getTaskRetriever().getTasks(this, userObj);
    }

    public boolean guaranteesSameTaskSet(BonsaiTreeNode node) {
        String compKey = node.getTaskRetrieverKey();
        if (this.taskRetrieverKey == null && compKey == null) {
            return true;
        }
        if (this.taskRetrieverKey == null || compKey == null) {
            return false;
        }
        if (this.taskRetrieverKey.equals(compKey)) {
            return this.getTaskRetriever().returnsSameTasks(this, node);
        }
        return false;
    }

    protected TaskRetriever getTaskRetriever() {
        return TaskManager.getTaskManager().getTaskRetriever(this.taskRetrieverKey);
    }

    public NavigationTreeNodeBean getNavigationTreeNodeBean(UserObject userObj) {
        UIInfo uiInfo = this.getUIInfo();
        Locale locale = userObj.getLocale();
        return new NavigationTreeNodeBean(this.id, uiInfo.getName(locale), uiInfo.getCaption(locale), uiInfo.getImageURL());
    }

    public Map getTableProperties(UserObject userObj) {
        Locale locale = userObj.getLocale();
        UIInfo uiInfo = this.getUIInfo();
        HashMap<String, Object> properties = new HashMap<String, Object>(4);
        String key = null;
        Iterator i = TABLE_PROPERTIES.iterator();
        while (i.hasNext()) {
            key = (String)i.next();
            if (key.equals("Name")) {
                properties.put(key, new NameTableCellBean(uiInfo.getName(locale), null, uiInfo.getImageURL(), uiInfo.getImageName(), this.getId()));
                continue;
            }
            if (!key.equals("Caption")) continue;
            properties.put(key, uiInfo.getCaption(locale));
        }
        properties.put("id", this.getId());
        return properties;
    }

    public boolean equals(Object obj) {
        try {
            if (obj == null) {
                return false;
            }
            return this.id.equals(((BonsaiTreeNode)obj).getId());
        }
        catch (ClassCastException ccEx) {
            return false;
        }
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return this.id;
    }

    static {
        TABLE_PROPERTIES.add("Name");
        TABLE_PROPERTIES.add("Caption");
    }
}

